﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Dziennik - wg dekretów</title>
		<script runat="server">
    void Grid1_OnBeforeRow(object sender, Soneta.Web.RowEventArgs args) {
      DekretBase dekret = (DekretBase)args.Row;
      colBufor.EditValue = dekret.Bufor ? "Tak" : "Nie";
      //colZamkniety.EditValue = dekret.Zamkniety ? "Tak" : "Nie";
      colWinien.EditValue = dekret.Winien.Value;
      colMa.EditValue = dekret.Ma.Value;
			if (dekret.Bufor && dekret.Wprowadzil != null)
				colOperator.EditValue = dekret.Wprowadzil.Name;
			if (!dekret.Bufor && dekret.Zatwierdzil != null)
				colOperator.EditValue = dekret.Zatwierdzil.Name;				
    }
    
    void DziennikWgDekretow_OnLoad(Object sender, EventArgs args){
        OkresObrachunkowy o         = (OkresObrachunkowy)DataContext1.Get(typeof(OkresObrachunkowy));
        Dziennik.Params p           = (Dziennik.Params)DataContext1.Get(typeof(Dziennik.Params));
        
        string tytul = "Dziennik - wg dekretów";
        if(p.TypDziennika==TypDziennika.BO)
          tytul = "Dziennik BO - wg dekretów";
        ReportHeader1.Title = 
          string.Format(ReportHeader1.Title, tytul, o, p.Zakres,
            p.Definicja==null ? "Wszystkie" : p.Definicja.ToString(), p.Bufor ? "Tak" : "Nie");
    }
		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="DziennikWgDekretow" method="post" runat="server" onload="DziennikWgDekretow_OnLoad">
			<P><ea:datacontext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business"></ea:datacontext>
				<cc1:ReportHeader id="ReportHeader1" title="{0} | Okres obrachunkowy: {1},  Za okres: {2} | Definicja: {3}, Uwzględniać bufor: {4}"
					runat="server"></cc1:ReportHeader><BR>
				<ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_OnBeforeRow" RowTypeName="Soneta.Ksiega.DekretBase,Soneta.Ksiega"
					RowsInRow="2" ShowPrevAgrSum="InFooter" ShowAgrSum="True" ShowPageSum="True">
					<Columns>
						<ea:GridColumn Align="Center" Caption="Bufor" ID="colBufor"></ea:GridColumn>
						<ea:GridColumn Align="Center" Caption="Operator" ID="colOperator"></ea:GridColumn>
						<ea:GridColumn DataMember="Numer" Caption="Nr"></ea:GridColumn>
						<ea:GridColumn Align="Center" DataMember="Data"></ea:GridColumn>
						<ea:GridColumn DataMember="NumerDokumentu" Caption="Nr dokumentu" EncodeHTML="true" ></ea:GridColumn>
						<ea:GridColumn Align="Center" DataMember="Ewidencja.DataDokumentu" Caption="Data dokumentu"></ea:GridColumn>
						<ea:GridColumn DataMember="Ewidencja.Numer.NumerPelny" Caption="Nr ewidencji" Total="Info"></ea:GridColumn>
						<ea:GridColumn ColSpan="3" DataMember="Opis" EncodeHTML="true"></ea:GridColumn>
						<ea:GridColumn Align="Right" Total="Sum" Caption="Winien" Format="{0:n}" ID="colWinien"></ea:GridColumn>
						<ea:GridColumn Align="Right" Total="Sum" Caption="Ma" Format="{0:n}" ID="colMa"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server">
					<Subtitles>
						<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter></P>
		</form>
	</body>
</HTML>

